--[[ 
	Gas Station Script
	------------------------------------------------------------------------------------------
	Created by DanielMan (danielman@x-plane.at) 2013 v1.0
	Features:
		- Refuels your Aircraft at Fuel Station
	
	Special Thanks to Carsten Lynker (X-Frise: http://forums.x-plane.org/index.php?showuser=82559 )
	for providing the FlyWithLUA Plug-In for X-Plane. 
]]	


require("graphics")

-- Local Variables -----------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------
local Refueling_Running = false
local Fuel_per_min = 0.5	-- Set the value you like for refuel speed [kg/sec]
------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------




-- Refuel --------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------
function GasStation_Refuel()
	set("sim/flightmodel/weight/m_fuel1", (get("sim/flightmodel/weight/m_fuel1")+Fuel_per_min))
	set("sim/flightmodel/weight/m_fuel2", (get("sim/flightmodel/weight/m_fuel2")+Fuel_per_min))
	set("sim/flightmodel/weight/m_fuel3", (get("sim/flightmodel/weight/m_fuel3")+Fuel_per_min))
	Refueling_Running = true
end
------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------



-- Gas Station ---------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------
function GasStation()
    
	local lat = get("sim/flightmodel/position/latitude")
	local lon = get("sim/flightmodel/position/longitude")
	
	
	if XPLMFindDataRef("STMA/Remote/KeyCode") ~=nil then
		if get("STMA/Scenery/HangarDoorPosition", 0) > 0.95 and get("sim/flightmodel/position/groundspeed") < 1 then
			
			--LOGW Unterfladnitz/Weiz
			if lat < 47.180 and lat > 47.160 and lon < 15.665 and lon > 15.663 then
				GasStation_Refuel()	-- Run Refuel
			end
			--
			-- Put in more Coordinates for your Gas Stations you would like to use
			--
			--
			--
			--	
			--
			--
			--
		else 
			Refueling_Running = false
		end
	end

	
end
------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------


-- Indication ----------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------
function GasStation_Indication()
	if Refueling_Running == true then
		draw_string(500, 500, "Refueling!!", "yellow")
	end
end
------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------



-- Function Call--------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------
do_often("GasStation()")	-- every second
do_every_draw("GasStation_Indication()")
------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------

